package gov.va.med.mhv.usermgmt.converter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.data.model.EmergencyContact;

public class EmergencyContactConverter extends AbstractConverter<EmergencyContactDTO, EmergencyContact> {
	private static Logger log = LogManager.getLogger(EmergencyContactConverter.class);

	@Override
	public EmergencyContactDTO convertFrom(EmergencyContact e) {
		EmergencyContactDTO dto = new EmergencyContactDTO();
		
		dto.setId(e.getEmergencyContactId());
		dto.setAddressCity(e.getCity());
		dto.setAddressPostalCode(e.getPostalCode());
		dto.setAddressProvince(e.getProvince());
		dto.setAddressCountry(e.getCountry());
		dto.setAddressState(e.getState());
		dto.setAddressStreet1(e.getAddressStreet1());
		dto.setAddressStreet2(e.getAddressStreet2());
		dto.setContactInfoContactMethod(e.getContactMethod());
		String contactMethod = e.getContactMethod();
		if (contactMethod != null) {
			if ("HomePhone".equals(contactMethod)) {
				dto.setContactInfoContactMethod("Home Phone");
			} else if ("MobilePhone".equals(contactMethod)) {
				dto.setContactInfoContactMethod("Mobile Phone");
			} else if ("WorkPhone".equals(contactMethod)) {
				dto.setContactInfoContactMethod("Work Phone");
			} else {
				dto.setContactInfoContactMethod(contactMethod);
			}
		}

		dto.setContactInfoEmail(e.getEmail());
		dto.setContactInfoFax(e.getFax());
		dto.setContactInfoHomePhone(e.getHomePhone());
		dto.setContactInfoMobilePhone(e.getMobilePhone());
		dto.setContactInfoPager(e.getPager());
		dto.setContactInfoWorkPhone(e.getWorkPhone());
		dto.setContactInfoWorkPhoneExt(e.getWorkPhoneExt());
		dto.setFirstName(e.getFirstName());
		dto.setId(e.getEmergencyContactId());
		dto.setIsPrimary(e.isPrimary());
		dto.setLastName(e.getLastName());
		dto.setMiddleName(e.getMiddleName());
		dto.setOplock(e.getOplock());
		dto.setPriority(e.getPriority());
		dto.setRelationship(e.getRelationship());
		dto.setSuffix(e.getSuffix());
		dto.setTitle(e.getTitle());
		dto.setUserProfileId(e.getUserProfileId());
		
		return dto;
	}

	@Override
	public EmergencyContact convertTo(EmergencyContactDTO dto) {
		EmergencyContact e = new EmergencyContact();
		
		e.setEmergencyContactId(dto.getId());
		e.setCity(dto.getAddressCity());
		e.setPostalCode(dto.getAddressPostalCode());
		e.setProvince(dto.getAddressProvince());
		e.setCountry(dto.getAddressCountry());
		if (dto.getAddressState() != null && "state".equalsIgnoreCase(dto.getAddressState())) {
			e.setState("");
		} else {
			e.setState(dto.getAddressState());
		}
		e.setAddressStreet1(dto.getAddressStreet1());
		e.setAddressStreet2(dto.getAddressStreet2());
		e.setContactMethod(dto.getContactInfoContactMethod());
		String contactMethod = dto.getContactInfoContactMethod();
		if (contactMethod != null) {
			if ("Home Phone".equals(contactMethod)) {
				e.setContactMethod("HomePhone");
			} else if ("Mobile Phone".equals(contactMethod)) {
				e.setContactMethod("MobilePhone");
			} else if ("Work Phone".equals(contactMethod)) {
				e.setContactMethod("WorkPhone");
			} else {
				e.setContactMethod(contactMethod);
			}
		}
		e.setEmail(dto.getContactInfoEmail());
		e.setFax(dto.getContactInfoFax());
		e.setHomePhone(dto.getContactInfoHomePhone());
		e.setMobilePhone(dto.getContactInfoMobilePhone());
		e.setPager(dto.getContactInfoPager());
		e.setWorkPhone(dto.getContactInfoWorkPhone());
		e.setWorkPhoneExt(dto.getContactInfoWorkPhoneExt());
		e.setFirstName(dto.getFirstName());
		e.setEmergencyContactId(dto.getId());
		e.setPrimary(dto.getIsPrimary());
		e.setLastName(dto.getLastName());
		e.setMiddleName(dto.getMiddleName());
		if (dto.getOplock() == null) {
			e.setOplock(0);
		} else {
			e.setOplock(dto.getOplock());
		}
		e.setPriority(dto.getPriority());
		e.setRelationship(dto.getRelationship());
		if (dto.getSuffix() != null && "Suffix".equalsIgnoreCase(dto.getSuffix())) {
			e.setSuffix("");
		} else {
			e.setSuffix(dto.getSuffix());
		}
		if (dto.getTitle() != null && "Title".equalsIgnoreCase(dto.getTitle())) {
			e.setTitle("");
		} else {
			e.setTitle(dto.getTitle());
		}
		e.setUserProfileId(dto.getUserProfileId());
		
		return e;
	}

}
